<?php 
return [
  'settings_title' => 'MultiPOS-Einstellungen',
  'help_text' => 'Verwalten und konfigurieren Sie Ihre POS-Geräte',
  'info' => [
    'registration_title' => 'Maschinenregistrierung',
    'registration_text' => 'Wenn Benutzer ohne registriertes Gerät auf die POS-Seite zugreifen, werden sie aufgefordert, dieses zu registrieren. Neue Registrierungen werden als „Ausstehend“ angezeigt und müssen genehmigt werden.',
    'status_title' => 'Statusleitfaden',
    'status_active' => 'Aktiv',
    'status_pending' => 'Ausstehend',
    'status_declined' => 'Abgelehnt',
    'status_active_text' => 'Genehmigt und kann Bestellungen bearbeiten',
    'status_pending_text' => 'Warten auf Genehmigung',
    'status_declined_text' => 'Zugriff verweigert. Bitte wenden Sie sich an den Administrator',
  ],
  'table' => [
    'registered_for_branch' => 'Registrierte Maschinen für die Filiale: :branch',
    'alias' => 'Alias',
    'machine_id' => 'Maschinen-ID',
    'status' => 'Status',
    'last_seen' => 'Zuletzt gesehen',
    'registered' => 'Eingetragen',
    'actions' => 'Aktionen',
    'no_alias' => 'Kein Alias',
    'never' => 'Niemals',
    'no_machines' => 'Keine Maschinen registriert',
    'no_machines_hint' => 'Geräte werden hier angezeigt, wenn Benutzer sie auf der POS-Seite registrieren.',
  ],
  'actions' => [
    'approve' => 'Genehmigen',
    'decline' => 'Abfall',
    'save' => 'Speichern',
    'cancel' => 'Stornieren',
    'edit' => 'Bearbeiten',
    'delete' => 'Löschen',
  ],
  'usage' => [
    'title' => 'Nutzung des POS-Geräts (:Monat, Jahr)',
    'no_data' => 'Für dieses Restaurant wurden in :monthYear keine POS-Automaten gefunden',
    'headers' => [
      'no' => 'NEIN.',
      'alias' => 'Maschinenalias',
      'branch' => 'Zweig',
      'machine_id' => 'Maschinen-ID',
      'status' => 'Status',
      'orders_current_month' => 'Bestellungen (aktueller Monat)',
      'revenue_current_month' => 'Umsatz (aktueller Monat)',
      'last_seen' => 'Zuletzt gesehen',
    ],
  ],
  'machines' => [
    'title' => 'Verwaltung von POS-Maschinen',
    'pending_approvals' => 'Ausstehende Genehmigungen (:count)',
    'filters' => [
      'all' => 'Alle Maschinen',
      'active' => 'Aktiv',
      'pending' => 'Ausstehend',
      'declined' => 'Abgelehnt',
    ],
    'table' => [
      'alias' => 'Alias',
      'machine_id' => 'Maschinen-ID',
      'status' => 'Status',
      'last_seen' => 'Zuletzt gesehen',
      'created' => 'Erstellt',
      'actions' => 'Aktionen',
      'no_alias' => 'Kein Alias',
    ],
    'buttons' => [
      'view' => 'Sicht',
      'approve' => 'Genehmigen',
      'edit' => 'Bearbeiten',
      'decline' => 'Abfall',
    ],
    'empty' => [
      'title' => 'Keine Maschinen registriert',
      'hint' => 'Geräte werden hier angezeigt, sobald sie auf der POS-Seite registriert wurden.',
    ],
    'modal' => [
      'title' => 'Maschinendetails',
      'statistics' => 'Statistiken',
      'total_orders' => 'Gesamtbestellungen',
      'today_orders' => 'Heutige Befehle',
    ],
    'confirm' => [
      'approve' => 'Diesen Kassenautomaten genehmigen?',
      'decline' => 'Diesen Kassenautomaten deaktivieren? Es ist eine erneute Registrierung erforderlich.',
    ],
  ],
  'reports' => [
    'title' => 'POS-Maschinenbericht',
    'filter' => 'Filter',
    'export_csv' => 'CSV exportieren',
    'customDateRange' => 'Benutzerdefinierter Datumsbereich',
    'pos_only' => 'Nur POS-weise',
    'pos_machine' => 'POS-Maschine',
    'cards' => [
      'total_machines' => 'Gesamtmaschinen',
      'total_orders' => 'Gesamtbestellungen',
      'net_sales' => 'Nettoumsatz',
      'avg_order_value' => 'Durchschnittlicher Bestellwert',
    ],
    'table' => [
      'title' => 'Maschinenleistung',
      'pos_machine' => 'POS-Maschine',
      'orders' => 'Bestellungen',
      'net_sales' => 'Nettoumsatz',
      'avg_order' => 'Durchschnittliche Bestellung',
      'cash_sales' => 'Barverkauf',
      'card_upi_sales' => 'Karten-/UPI-Verkäufe',
      'refunds' => 'Rückerstattungen',
    ],
    'empty' => [
      'title' => 'Keine Daten verfügbar',
      'hint' => 'Versuchen Sie, einen anderen Datumsbereich auszuwählen.',
    ],
  ],
  'registration' => [
    'declined' => [
      'title' => 'Registrierung abgelehnt',
      'message' => 'Ihre POS-Registrierungsanfrage wurde abgelehnt. Bitte wenden Sie sich für Unterstützung an Ihren Administrator.',
      'check_status' => 'Überprüfen Sie den Status erneut',
    ],
    'pending' => [
      'title' => 'Anmeldung steht noch aus',
      'message' => 'Warten auf die Genehmigung des Administrators. Der POS-Zugriff ist derzeit blockiert, bis Ihr Gerät genehmigt wurde.',
      'refresh_status' => 'Status aktualisieren',
      'approve_this_machine' => 'Genehmigen Sie diese Maschine',
      'go_to_settings' => 'Gehen Sie zu Einstellungen',
    ],
    'active' => [
      'label' => 'POS:',
    ],
    'limit_reached' => [
      'title' => 'Limit des POS-Geräts erreicht',
      'message' => 'Das POS-Maschinenlimit für diese Filiale wurde erreicht (Limit: :limit). Bitte wenden Sie sich an Ihren Administrator.',
      'what_can_you_do' => 'Was können Sie tun?',
      'hint' => 'Wenden Sie sich an Ihren Administrator, um das POS-Maschinenlimit zu erhöhen oder inaktive Maschinen zu entfernen.',
    ],
    'form' => [
      'title' => 'Registrieren Sie dieses Gerät als POS',
      'description' => 'Um das Kassensystem nutzen zu können, muss dieses Gerät registriert werden. Alle Bestellungen werden mit diesem Gerät verknüpft.',
      'select_branch' => 'Wählen Sie Zweig aus',
      'select_branch_placeholder' => 'Wählen Sie eine Filiale...',
      'select_branch_error' => 'Bitte wählen Sie eine Filiale aus',
      'device_name' => 'Gerätename (optional)',
      'device_name_placeholder' => 'z. B. Theke 1, Bar-POS, Kiosk 1',
      'device_name_hint' => 'Geben Sie diesem Gerät zur leichteren Identifizierung einen benutzerfreundlichen Namen.',
      'what_happens_next' => 'Was passiert als nächstes?',
      'what_happens_next_text' => 'Nach der Registrierung benötigen Sie die Genehmigung des Administrators, bevor das Gerät aktiv wird.',
      'register_button' => 'Gerät registrieren',
      'cancel_button' => 'Abbrechen und zurückgehen',
      'go_to_dashboard' => 'Gehen Sie zum Dashboard',
    ],
    'device' => 'Gerät',
    'already_registered' => 'Dieses Gerät ist bereits als :alias registriert.',
    'limit_reached_error' => 'Das POS-Maschinenlimit für diese Filiale wurde erreicht (Limit: :limit). Bitte wenden Sie sich an Ihren Administrator.',
    'registered_success' => 'POS-Gerät erfolgreich registriert und aktiviert als :alias (:public_id)',
    'registered_pending' => 'Ihre Registrierungsanfrage wurde übermittelt. Warten auf die Genehmigung des Administrators. Nach der Genehmigung können Sie den POS nutzen.',
  ],
  'settings' => [
    'machine_not_pending' => 'Die Genehmigung der Maschine steht nicht aus',
    'user_not_found' => 'Benutzer nicht gefunden',
    'machine_approved' => 'Maschine erfolgreich genehmigt',
    'machine_already_declined' => 'Die Maschine wurde bereits abgelehnt',
    'machine_declined' => 'Die Maschine wurde erfolgreich abgelehnt',
    'alias_required' => 'Alias ​​ist erforderlich',
    'machine_updated' => 'Maschine erfolgreich aktualisiert',
    'machine_deleted' => 'Maschine erfolgreich gelöscht',
    'delete_machine_title' => 'Kassengerät löschen?',
    'delete_machine_message' => 'Sind Sie sicher, dass Sie diesen POS-Automaten löschen möchten? Diese Aktion kann nicht rückgängig gemacht werden.',
  ],
  'js' => [
    'network_error' => 'Die Netzwerkantwort war nicht in Ordnung',
    'error_checking_limit' => 'Fehler beim Überprüfen des Verzweigungslimits',
    'limit_reached_message' => 'Das POS-Maschinenlimit für diese Filiale wurde erreicht (Limit: :limit). Bitte wenden Sie sich an Ihren Administrator.',
    'error_loading_report' => 'Fehler beim Laden der Berichtsdaten. Bitte versuchen Sie es erneut.',
    'edit_coming_soon' => 'Die Bearbeitungsfunktion ist in Kürze verfügbar',
    'unnamed' => 'Unbenannt',
  ],
  'dashboard' => [
    'title' => 'MultiPOS-Management',
    'manage_terminals' => 'Terminals verwalten',
    'settings' => 'Einstellungen',
    'pos_machines_branch' => 'POS-Automaten (Filiale)',
    'unlimited' => 'Unbegrenzt',
    'active_limit' => '(Aktiv / Limit)',
    'pending_label' => 'Ausstehend:',
    'total_terminals' => 'Gesamtzahl der Terminals',
    'active_orders' => 'Aktive Bestellungen',
    'todays_revenue' => 'Heutige Einnahmen',
    'total_tables' => 'Gesamttabellen',
    'quick_actions' => 'Schnelle Aktionen',
    'pos_terminal' => 'POS-Terminal',
    'take_orders' => 'Nehmen Sie Bestellungen entgegen',
    'configure_pos_terminals' => 'Konfigurieren Sie POS-Terminals',
    'configure_multipos' => 'Konfigurieren Sie MultiPOS',
    'branch_label' => 'Zweig:',
    'used_label' => 'Gebraucht:',
  ],
  'claim' => [
    'title' => 'Registrieren Sie dieses Gerät als POS',
    'description' => 'Dadurch wird Ihr aktuelles Gerät registriert, um Bestellungen und Kassensitzungen zu verfolgen.',
    'branch_label' => 'Zweig',
    'branch_required' => 'Zweig',
    'select_branch' => 'Wählen Sie eine Filiale aus',
    'device_alias_label' => 'Gerätealias (optional)',
    'device_alias_placeholder' => 'z. B. Theke 1, Bar-POS, Kiosk 1',
    'device_alias_hint' => 'Geben Sie diesem Gerät zur leichteren Identifizierung einen benutzerfreundlichen Namen.',
    'what_happens_next_title' => 'Was passiert als nächstes?',
    'what_happens_next_message' => 'Nach der Registrierung wird dieses Gerät für alle Bestellungen und Transaktionen getrackt. Ihr Administrator muss dieses Gerät möglicherweise genehmigen, bevor es aktiv wird.',
    'cancel' => 'Stornieren',
    'register_device' => 'Gerät registrieren',
    'select_branch_alert' => 'Bitte wählen Sie eine Filiale aus',
  ],
  'terminals' => [
    'title' => 'Verwaltung von POS-Terminals',
    'pos_terminals' => 'POS-Terminals',
    'add_terminal' => 'Terminal hinzufügen',
    'back_to_dashboard' => 'Zurück zum Dashboard',
    'edit_terminal' => 'Terminal bearbeiten',
    'delete_terminal' => 'Löschen',
    'no_terminals' => 'Keine Terminals',
    'get_started' => 'Beginnen Sie mit der Erstellung eines neuen POS-Terminals.',
    'terminal_name' => 'Terminalname',
    'type' => 'Typ',
    'active' => 'Aktiv',
    'cancel' => 'Stornieren',
    'save' => 'Speichern',
    'delete_confirm' => 'Sind Sie sicher, dass Sie dieses Terminal löschen möchten?',
    'table' => [
      'name' => 'Name',
      'type' => 'Typ',
      'printer' => 'Drucker',
      'status' => 'Status',
      'default' => 'Standard',
      'actions' => 'Aktionen',
    ],
    'status' => [
      'active' => 'Aktiv',
      'inactive' => 'Inaktiv',
    ],
    'type_options' => [
      'food' => 'Essen',
      'beverage' => 'Getränk',
      'general' => 'Allgemein',
    ],
    'no_printer' => 'Kein Drucker',
    'default' => 'Standard',
  ],
  'package' => [
    'multiposLimit' => 'MultiPOS-Maschinenlimit',
    'multiposLimitInfo' => 'Dies ist eine verzweigte Grenze. Geben Sie -1 für unbegrenzte POS-Geräte pro Filiale ein. Lassen Sie das Feld leer oder legen Sie eine positive Zahl fest, um ein Limit pro Zweig festzulegen.',
  ],
  'notifications' => [
    'pos_request' => [
      'subject' => 'Registrierungsanfrage für einen neuen POS-Automaten',
      'push_title' => 'POS-Registrierungsanfrage',
      'push_message' => ':alias hat POS-Zugriff für die :branch-Filiale angefordert',
      'text1' => 'Es wurde eine neue Registrierungsanfrage für einen POS-Automaten eingereicht.',
      'text2' => 'Bitte überprüfen und genehmigen Sie die Anfrage oder lehnen Sie sie ab:',
      'text3' => 'Sie können alle POS-Maschinenanfragen über die MultiPOS-Einstellungsseite verwalten.',
      'action' => 'Überprüfungsanfrage',
    ],
  ],
];