<?php 
return [
  'settings_title' => 'Configuraciones multiPOS',
  'help_text' => 'Gestiona y configura tus máquinas POS',
  'info' => [
    'registration_title' => 'Registro de máquina',
    'registration_text' => 'Cuando los usuarios accedan a la página POS sin un dispositivo registrado, se les pedirá que lo registren. Los nuevos registros aparecen como "Pendientes" y requieren aprobación.',
    'status_title' => 'Guía de estado',
    'status_active' => 'Activo',
    'status_pending' => 'Pendiente',
    'status_declined' => 'Rechazado',
    'status_active_text' => 'Aprobado y puede procesar pedidos.',
    'status_pending_text' => 'En espera de aprobación',
    'status_declined_text' => 'Acceso denegado, por favor contacte al administrador',
  ],
  'table' => [
    'registered_for_branch' => 'Máquinas Registradas para Sucursal: :branch',
    'alias' => 'Alias',
    'machine_id' => 'ID de máquina',
    'status' => 'Estado',
    'last_seen' => 'Visto por última vez',
    'registered' => 'Registrado',
    'actions' => 'Comportamiento',
    'no_alias' => 'Sin alias',
    'never' => 'Nunca',
    'no_machines' => 'No hay máquinas registradas',
    'no_machines_hint' => 'Los dispositivos aparecerán aquí cuando los usuarios los registren desde la página POS.',
  ],
  'actions' => [
    'approve' => 'Aprobar',
    'decline' => 'Rechazar',
    'save' => 'Ahorrar',
    'cancel' => 'Cancelar',
    'edit' => 'Editar',
    'delete' => 'Borrar',
  ],
  'usage' => [
    'title' => 'Uso de la máquina POS (:mes Año)',
    'no_data' => 'No se encontraron máquinas POS para este restaurante en :monthYear',
    'headers' => [
      'no' => 'No.',
      'alias' => 'Alias ​​de máquina',
      'branch' => 'Rama',
      'machine_id' => 'ID de máquina',
      'status' => 'Estado',
      'orders_current_month' => 'Pedidos (mes actual)',
      'revenue_current_month' => 'Ingresos (mes actual)',
      'last_seen' => 'Visto por última vez',
    ],
  ],
  'machines' => [
    'title' => 'Gestión de Máquinas POS',
    'pending_approvals' => 'Aprobaciones pendientes (:count)',
    'filters' => [
      'all' => 'Todas las maquinas',
      'active' => 'Activo',
      'pending' => 'Pendiente',
      'declined' => 'Rechazado',
    ],
    'table' => [
      'alias' => 'Alias',
      'machine_id' => 'ID de máquina',
      'status' => 'Estado',
      'last_seen' => 'Visto por última vez',
      'created' => 'Creado',
      'actions' => 'Comportamiento',
      'no_alias' => 'Sin alias',
    ],
    'buttons' => [
      'view' => 'Vista',
      'approve' => 'Aprobar',
      'edit' => 'Editar',
      'decline' => 'Rechazar',
    ],
    'empty' => [
      'title' => 'No hay máquinas registradas',
      'hint' => 'Los dispositivos aparecerán aquí una vez que estén registrados desde la página POS.',
    ],
    'modal' => [
      'title' => 'Detalles de la máquina',
      'statistics' => 'Estadística',
      'total_orders' => 'Órdenes totales',
      'today_orders' => 'Pedidos de hoy',
    ],
    'confirm' => [
      'approve' => '¿Aprobar esta máquina POS?',
      'decline' => '¿Desactivar esta máquina POS? Será necesario volver a registrarse.',
    ],
  ],
  'reports' => [
    'title' => 'Informe de máquina POS',
    'filter' => 'Filtrar',
    'export_csv' => 'Exportar CSV',
    'customDateRange' => 'Rango de fechas personalizado',
    'pos_only' => 'Solo en punto de venta',
    'pos_machine' => 'Máquina POS',
    'cards' => [
      'total_machines' => 'Máquinas totales',
      'total_orders' => 'Órdenes totales',
      'net_sales' => 'Ventas Netas',
      'avg_order_value' => 'Valor promedio del pedido',
    ],
    'table' => [
      'title' => 'Rendimiento de la máquina',
      'pos_machine' => 'Máquina POS',
      'orders' => 'Órdenes',
      'net_sales' => 'Ventas Netas',
      'avg_order' => 'Orden promedio',
      'cash_sales' => 'Ventas en efectivo',
      'card_upi_sales' => 'Ventas de tarjetas/UPI',
      'refunds' => 'Reembolsos',
    ],
    'empty' => [
      'title' => 'No hay datos disponibles',
      'hint' => 'Intente seleccionar un rango de fechas diferente.',
    ],
  ],
  'registration' => [
    'declined' => [
      'title' => 'Registro rechazado',
      'message' => 'Su solicitud de registro de POS ha sido rechazada. Comuníquese con su administrador para obtener ayuda.',
      'check_status' => 'Verifique el estado nuevamente',
    ],
    'pending' => [
      'title' => 'Registro Pendiente',
      'message' => 'Esperando la aprobación del administrador. El acceso a POS está actualmente bloqueado hasta que se apruebe su dispositivo.',
      'refresh_status' => 'Actualizar estado',
      'approve_this_machine' => 'Aprobar esta máquina',
      'go_to_settings' => 'Ir a configuración',
    ],
    'active' => [
      'label' => 'Punto de venta:',
    ],
    'limit_reached' => [
      'title' => 'Se alcanzó el límite de la máquina POS',
      'message' => 'Se alcanzó el límite de máquinas POS para esta sucursal (límite: :limit). Por favor contacte a su administrador.',
      'what_can_you_do' => '¿Qué puedes hacer?',
      'hint' => 'Comuníquese con su administrador para aumentar el límite de máquinas POS o eliminar máquinas inactivas.',
    ],
    'form' => [
      'title' => 'Registre este dispositivo como POS',
      'description' => 'Para utilizar el sistema POS, este dispositivo debe estar registrado. Todos los pedidos estarán vinculados a este dispositivo.',
      'select_branch' => 'Seleccionar Sucursal',
      'select_branch_placeholder' => 'Elige una sucursal...',
      'select_branch_error' => 'Por favor seleccione una sucursal',
      'device_name' => 'Nombre del dispositivo (opcional)',
      'device_name_placeholder' => 'por ejemplo, mostrador 1, punto de venta de bar, quiosco 1',
      'device_name_hint' => 'Asigne a este dispositivo un nombre descriptivo para una fácil identificación.',
      'what_happens_next' => '¿Qué pasa después?',
      'what_happens_next_text' => 'Después del registro, necesitará la aprobación del administrador antes de que el dispositivo se active.',
      'register_button' => 'Registrar dispositivo',
      'cancel_button' => 'Cancelar y regresar',
      'go_to_dashboard' => 'Ir al panel',
    ],
    'device' => 'Dispositivo',
    'already_registered' => 'Este dispositivo ya está registrado como :alias.',
    'limit_reached_error' => 'Se alcanzó el límite de máquinas POS para esta sucursal (límite: :limit). Por favor contacte a su administrador.',
    'registered_success' => 'Dispositivo POS registrado y activado exitosamente como :alias (:public_id)',
    'registered_pending' => 'Su solicitud de registro ha sido enviada. Esperando la aprobación del administrador. Podrás utilizar el POS una vez aprobado.',
  ],
  'settings' => [
    'machine_not_pending' => 'La máquina no está pendiente de aprobación',
    'user_not_found' => 'Usuario no encontrado',
    'machine_approved' => 'Máquina aprobada con éxito',
    'machine_already_declined' => 'La máquina ya ha sido rechazada.',
    'machine_declined' => 'La máquina rechazó exitosamente',
    'alias_required' => 'Se requiere alias',
    'machine_updated' => 'Máquina actualizada exitosamente',
    'machine_deleted' => 'Máquina eliminada exitosamente',
    'delete_machine_title' => '¿Eliminar máquina POS?',
    'delete_machine_message' => '¿Está seguro de que desea eliminar esta máquina POS? Esta acción no se puede deshacer.',
  ],
  'js' => [
    'network_error' => 'La respuesta de la red no fue correcta',
    'error_checking_limit' => 'Error al comprobar el límite de sucursales',
    'limit_reached_message' => 'Se alcanzó el límite de máquinas POS para esta sucursal (límite: :limit). Por favor contacte a su administrador.',
    'error_loading_report' => 'Error al cargar los datos del informe. Por favor inténtalo de nuevo.',
    'edit_coming_soon' => 'Función de edición próximamente',
    'unnamed' => 'Sin nombre',
  ],
  'dashboard' => [
    'title' => 'Gestión MultiPOS',
    'manage_terminals' => 'Administrar terminales',
    'settings' => 'Ajustes',
    'pos_machines_branch' => 'Máquinas POS (Sucursal)',
    'unlimited' => 'Ilimitado',
    'active_limit' => '(Activo / Límite)',
    'pending_label' => 'Pendiente:',
    'total_terminals' => 'Terminales totales',
    'active_orders' => 'Órdenes activas',
    'todays_revenue' => 'Los ingresos de hoy',
    'total_tables' => 'Tablas totales',
    'quick_actions' => 'Acciones rápidas',
    'pos_terminal' => 'Terminal POS',
    'take_orders' => 'Ordenarse',
    'configure_pos_terminals' => 'Configurar terminales POS',
    'configure_multipos' => 'Configurar MultiPOS',
    'branch_label' => 'Rama:',
    'used_label' => 'Usado:',
  ],
  'claim' => [
    'title' => 'Registre este dispositivo como POS',
    'description' => 'Esto registrará su dispositivo actual para rastrear pedidos y sesiones de caja registradora.',
    'branch_label' => 'Rama',
    'branch_required' => 'Rama',
    'select_branch' => 'Seleccione una sucursal',
    'device_alias_label' => 'Alias ​​del dispositivo (opcional)',
    'device_alias_placeholder' => 'por ejemplo, mostrador 1, punto de venta de bar, quiosco 1',
    'device_alias_hint' => 'Asigne a este dispositivo un nombre descriptivo para una fácil identificación.',
    'what_happens_next_title' => '¿Qué pasa después?',
    'what_happens_next_message' => 'Después del registro, se rastreará este dispositivo para todos los pedidos y transacciones. Es posible que su administrador deba aprobar este dispositivo antes de que se active.',
    'cancel' => 'Cancelar',
    'register_device' => 'Registrar dispositivo',
    'select_branch_alert' => 'Por favor seleccione una sucursal',
  ],
  'terminals' => [
    'title' => 'Gestión de Terminales POS',
    'pos_terminals' => 'Terminales POS',
    'add_terminal' => 'Agregar terminal',
    'back_to_dashboard' => 'Volver al panel',
    'edit_terminal' => 'Editar terminal',
    'delete_terminal' => 'Borrar',
    'no_terminals' => 'Sin terminales',
    'get_started' => 'Comience creando una nueva terminal POS.',
    'terminal_name' => 'Nombre del terminal',
    'type' => 'Tipo',
    'active' => 'Activo',
    'cancel' => 'Cancelar',
    'save' => 'Ahorrar',
    'delete_confirm' => '¿Estás seguro de que quieres eliminar este terminal?',
    'table' => [
      'name' => 'Nombre',
      'type' => 'Tipo',
      'printer' => 'Impresora',
      'status' => 'Estado',
      'default' => 'Por defecto',
      'actions' => 'Comportamiento',
    ],
    'status' => [
      'active' => 'Activo',
      'inactive' => 'Inactivo',
    ],
    'type_options' => [
      'food' => 'Alimento',
      'beverage' => 'Bebida',
      'general' => 'General',
    ],
    'no_printer' => 'Sin impresora',
    'default' => 'Por defecto',
  ],
  'package' => [
    'multiposLimit' => 'Límite de máquina multiPOS',
    'multiposLimitInfo' => 'Este es un límite por sucursales. Ingrese -1 para máquinas POS ilimitadas por sucursal. Déjelo en blanco o establezca un número positivo para establecer un límite por sucursal.',
  ],
  'notifications' => [
    'pos_request' => [
      'subject' => 'Solicitud de registro de nueva máquina POS',
      'push_title' => 'Solicitud de Registro TPV',
      'push_message' => ':alias ha solicitado acceso POS para sucursal :branch',
      'text1' => 'Se ha enviado una nueva solicitud de registro de máquina POS.',
      'text2' => 'Revise y apruebe o rechace la solicitud:',
      'text3' => 'Puede administrar todas las solicitudes de máquinas POS desde la página de configuración de MultiPOS.',
      'action' => 'Solicitud de revisión',
    ],
  ],
];