<?php 
return [
  'settings_title' => 'Paramètres MultiPOS',
  'help_text' => 'Gérez et configurez vos machines POS',
  'info' => [
    'registration_title' => 'Enregistrement de la machine',
    'registration_text' => 'Lorsque les utilisateurs accèdent à la page PDV sans appareil enregistré, ils seront invités à l\'enregistrer. Les nouvelles inscriptions apparaissent comme « En attente » et nécessitent une approbation.',
    'status_title' => 'Guide d\'état',
    'status_active' => 'Actif',
    'status_pending' => 'En attente',
    'status_declined' => 'Refusé',
    'status_active_text' => 'Approuvé et peut traiter les commandes',
    'status_pending_text' => 'En attente d\'approbation',
    'status_declined_text' => 'Accès refusé, veuillez contacter l\'administrateur',
  ],
  'table' => [
    'registered_for_branch' => 'Machines enregistrées pour la succursale : :branch',
    'alias' => 'Alias',
    'machine_id' => 'ID de l\'ordinateur',
    'status' => 'Statut',
    'last_seen' => 'Vu pour la dernière fois',
    'registered' => 'Inscrit',
    'actions' => 'Actes',
    'no_alias' => 'Pas d\'alias',
    'never' => 'Jamais',
    'no_machines' => 'Aucune machine enregistrée',
    'no_machines_hint' => 'Les appareils apparaîtront ici lorsque les utilisateurs les enregistreront à partir de la page PDV.',
  ],
  'actions' => [
    'approve' => 'Approuver',
    'decline' => 'Déclin',
    'save' => 'Sauvegarder',
    'cancel' => 'Annuler',
    'edit' => 'Modifier',
    'delete' => 'Supprimer',
  ],
  'usage' => [
    'title' => 'Utilisation de la machine POS (:mois Année)',
    'no_data' => 'Aucune machine POS trouvée pour ce restaurant en :monthYear',
    'headers' => [
      'no' => 'Non.',
      'alias' => 'Alias ​​de la machine',
      'branch' => 'Bifurquer',
      'machine_id' => 'ID de l\'ordinateur',
      'status' => 'Statut',
      'orders_current_month' => 'Commandes (mois en cours)',
      'revenue_current_month' => 'Revenus (mois en cours)',
      'last_seen' => 'Vu pour la dernière fois',
    ],
  ],
  'machines' => [
    'title' => 'Gestion des machines POS',
    'pending_approvals' => 'Approbations en attente (:count)',
    'filters' => [
      'all' => 'Toutes les machines',
      'active' => 'Actif',
      'pending' => 'En attente',
      'declined' => 'Refusé',
    ],
    'table' => [
      'alias' => 'Alias',
      'machine_id' => 'ID de l\'ordinateur',
      'status' => 'Statut',
      'last_seen' => 'Vu pour la dernière fois',
      'created' => 'Créé',
      'actions' => 'Actes',
      'no_alias' => 'Pas d\'alias',
    ],
    'buttons' => [
      'view' => 'Voir',
      'approve' => 'Approuver',
      'edit' => 'Modifier',
      'decline' => 'Déclin',
    ],
    'empty' => [
      'title' => 'Aucune machine enregistrée',
      'hint' => 'Les appareils apparaîtront ici une fois qu\'ils seront enregistrés à partir de la page PDV.',
    ],
    'modal' => [
      'title' => 'Détails de la machine',
      'statistics' => 'Statistiques',
      'total_orders' => 'Total des commandes',
      'today_orders' => 'Les commandes du jour',
    ],
    'confirm' => [
      'approve' => 'Approuver cette machine POS ?',
      'decline' => 'Désactiver cette machine POS ? Il devra se réinscrire.',
    ],
  ],
  'reports' => [
    'title' => 'Rapport sur les machines de point de vente',
    'filter' => 'Filtre',
    'export_csv' => 'Exporter au format CSV',
    'customDateRange' => 'Plage de dates personnalisée',
    'pos_only' => 'POS sage uniquement',
    'pos_machine' => 'Machine de point de vente',
    'cards' => [
      'total_machines' => 'Total des machines',
      'total_orders' => 'Total des commandes',
      'net_sales' => 'Ventes nettes',
      'avg_order_value' => 'Valeur moyenne de la commande',
    ],
    'table' => [
      'title' => 'Performances des machines',
      'pos_machine' => 'Machine de point de vente',
      'orders' => 'Ordres',
      'net_sales' => 'Ventes nettes',
      'avg_order' => 'Commande moyenne',
      'cash_sales' => 'Ventes au comptant',
      'card_upi_sales' => 'Ventes de cartes/UPI',
      'refunds' => 'Remboursements',
    ],
    'empty' => [
      'title' => 'Aucune donnée disponible',
      'hint' => 'Essayez de sélectionner une autre plage de dates.',
    ],
  ],
  'registration' => [
    'declined' => [
      'title' => 'Inscription refusée',
      'message' => 'Votre demande d\'inscription au point de vente a été refusée. Veuillez contacter votre administrateur pour obtenir de l\'aide.',
      'check_status' => 'Vérifier à nouveau l\'état',
    ],
    'pending' => [
      'title' => 'Inscription en attente',
      'message' => 'En attente de l\'approbation de l\'administrateur. L\'accès au point de vente est actuellement bloqué jusqu\'à ce que votre appareil soit approuvé.',
      'refresh_status' => 'Actualiser le statut',
      'approve_this_machine' => 'Approuver cette machine',
      'go_to_settings' => 'Allez dans Paramètres',
    ],
    'active' => [
      'label' => 'PDV :',
    ],
    'limit_reached' => [
      'title' => 'Limite de machine POS atteinte',
      'message' => 'Limite de machines POS atteinte pour cette succursale (limite : :limit). Veuillez contacter votre administrateur.',
      'what_can_you_do' => 'Que pouvez-vous faire ?',
      'hint' => 'Contactez votre administrateur pour augmenter la limite des machines POS ou supprimer les machines inactives.',
    ],
    'form' => [
      'title' => 'Enregistrez cet appareil en tant que point de vente',
      'description' => 'Pour utiliser le système POS, cet appareil doit être enregistré. Toutes les commandes seront liées à cet appareil.',
      'select_branch' => 'Sélectionnez une succursale',
      'select_branch_placeholder' => 'Choisissez une succursale...',
      'select_branch_error' => 'Veuillez sélectionner une succursale',
      'device_name' => 'Nom de l\'appareil (facultatif)',
      'device_name_placeholder' => 'par exemple, comptoir 1, bar POS, kiosque 1',
      'device_name_hint' => 'Donnez à cet appareil un nom convivial pour une identification facile.',
      'what_happens_next' => 'Que se passe-t-il ensuite ?',
      'what_happens_next_text' => 'Après l\'inscription, vous aurez besoin de l\'approbation de l\'administrateur avant que l\'appareil ne devienne actif.',
      'register_button' => 'Enregistrer l\'appareil',
      'cancel_button' => 'Annuler et revenir en arrière',
      'go_to_dashboard' => 'Aller au tableau de bord',
    ],
    'device' => 'Appareil',
    'already_registered' => 'Cet appareil est déjà enregistré en tant que :alias.',
    'limit_reached_error' => 'Limite de machines POS atteinte pour cette succursale (limite : :limit). Veuillez contacter votre administrateur.',
    'registered_success' => 'Appareil POS enregistré et activé avec succès en tant que :alias (:public_id)',
    'registered_pending' => 'Votre demande d\'inscription a été soumise. En attente de l\'approbation de l\'administrateur. Vous pourrez utiliser le PDV une fois approuvé.',
  ],
  'settings' => [
    'machine_not_pending' => 'La machine n\'est pas en attente d\'approbation',
    'user_not_found' => 'Utilisateur introuvable',
    'machine_approved' => 'Machine approuvée avec succès',
    'machine_already_declined' => 'La machine est déjà refusée',
    'machine_declined' => 'La machine a été refusée avec succès',
    'alias_required' => 'L\'alias est requis',
    'machine_updated' => 'Machine mise à jour avec succès',
    'machine_deleted' => 'Machine supprimée avec succès',
    'delete_machine_title' => 'Supprimer le terminal PDV ?',
    'delete_machine_message' => 'Etes-vous sûr de vouloir supprimer cette machine POS ? Cette action ne peut pas être annulée.',
  ],
  'js' => [
    'network_error' => 'La réponse du réseau n\'était pas correcte',
    'error_checking_limit' => 'Erreur lors de la vérification de la limite de branche',
    'limit_reached_message' => 'Limite de machines POS atteinte pour cette succursale (limite : :limit). Veuillez contacter votre administrateur.',
    'error_loading_report' => 'Erreur lors du chargement des données du rapport. Veuillez réessayer.',
    'edit_coming_soon' => 'Fonctionnalité d\'édition à venir',
    'unnamed' => 'Anonyme',
  ],
  'dashboard' => [
    'title' => 'Gestion MultiPOS',
    'manage_terminals' => 'Gérer les terminaux',
    'settings' => 'Paramètres',
    'pos_machines_branch' => 'Machines de point de vente (succursale)',
    'unlimited' => 'Illimité',
    'active_limit' => '(Actif / Limite)',
    'pending_label' => 'En attente:',
    'total_terminals' => 'Total des terminaux',
    'active_orders' => 'Commandes actives',
    'todays_revenue' => 'Les revenus d\'aujourd\'hui',
    'total_tables' => 'Tableaux totaux',
    'quick_actions' => 'Actions rapides',
    'pos_terminal' => 'Terminal de point de vente',
    'take_orders' => 'Prendre les commandes',
    'configure_pos_terminals' => 'Configurer les terminaux de point de vente',
    'configure_multipos' => 'Configurer MultiPOS',
    'branch_label' => 'Bifurquer:',
    'used_label' => 'Utilisé:',
  ],
  'claim' => [
    'title' => 'Enregistrez cet appareil en tant que point de vente',
    'description' => 'Cela enregistrera votre appareil actuel pour suivre les commandes et les sessions de caisse.',
    'branch_label' => 'Bifurquer',
    'branch_required' => 'Bifurquer',
    'select_branch' => 'Sélectionnez une succursale',
    'device_alias_label' => 'Alias ​​de l\'appareil (facultatif)',
    'device_alias_placeholder' => 'par exemple, comptoir 1, bar POS, kiosque 1',
    'device_alias_hint' => 'Donnez à cet appareil un nom convivial pour une identification facile.',
    'what_happens_next_title' => 'Que se passe-t-il ensuite ?',
    'what_happens_next_message' => 'Après l\'enregistrement, cet appareil sera suivi pour toutes les commandes et transactions. Votre administrateur devra peut-être approuver cet appareil avant qu\'il ne devienne actif.',
    'cancel' => 'Annuler',
    'register_device' => 'Enregistrer l\'appareil',
    'select_branch_alert' => 'Veuillez sélectionner une succursale',
  ],
  'terminals' => [
    'title' => 'Gestion des terminaux de point de vente',
    'pos_terminals' => 'Terminaux PDV',
    'add_terminal' => 'Ajouter un terminal',
    'back_to_dashboard' => 'Retour au tableau de bord',
    'edit_terminal' => 'Modifier le terminal',
    'delete_terminal' => 'Supprimer',
    'no_terminals' => 'Pas de bornes',
    'get_started' => 'Commencez par créer un nouveau terminal de point de vente.',
    'terminal_name' => 'Nom du terminal',
    'type' => 'Taper',
    'active' => 'Actif',
    'cancel' => 'Annuler',
    'save' => 'Sauvegarder',
    'delete_confirm' => 'Êtes-vous sûr de vouloir supprimer ce terminal ?',
    'table' => [
      'name' => 'Nom',
      'type' => 'Taper',
      'printer' => 'Imprimante',
      'status' => 'Statut',
      'default' => 'Défaut',
      'actions' => 'Actes',
    ],
    'status' => [
      'active' => 'Actif',
      'inactive' => 'Inactif',
    ],
    'type_options' => [
      'food' => 'Nourriture',
      'beverage' => 'Boisson',
      'general' => 'Général',
    ],
    'no_printer' => 'Pas d\'imprimante',
    'default' => 'Défaut',
  ],
  'package' => [
    'multiposLimit' => 'Limite des machines MultiPOS',
    'multiposLimitInfo' => 'Il s\'agit d\'une limite par branche. Entrez -1 pour un nombre illimité de machines POS par succursale. Laissez vide ou définissez un nombre positif pour définir une limite par branche.',
  ],
  'notifications' => [
    'pos_request' => [
      'subject' => 'Demande d\'enregistrement d\'une nouvelle machine POS',
      'push_title' => 'Demande d\'inscription au point de vente',
      'push_message' => ':alias a demandé un accès au point de vente pour la succursale :branch',
      'text1' => 'Une nouvelle demande d\'enregistrement de machine POS a été soumise.',
      'text2' => 'Veuillez examiner et approuver ou refuser la demande :',
      'text3' => 'Vous pouvez gérer toutes les demandes de machines POS à partir de la page des paramètres MultiPOS.',
      'action' => 'Demande de révision',
    ],
  ],
];