<?php 
return [
  'settings_title' => 'Impostazioni MultiPOS',
  'help_text' => 'Gestisci e configura le tue macchine POS',
  'info' => [
    'registration_title' => 'Registrazione della macchina',
    'registration_text' => 'Quando gli utenti accedono alla pagina POS senza un dispositivo registrato, verrà loro richiesto di registrarlo. Le nuove registrazioni appaiono come "In sospeso" e richiedono l\'approvazione.',
    'status_title' => 'Guida allo stato',
    'status_active' => 'Attivo',
    'status_pending' => 'In attesa di',
    'status_declined' => 'Rifiutato',
    'status_active_text' => 'Approvato e può elaborare gli ordini',
    'status_pending_text' => 'In attesa di approvazione',
    'status_declined_text' => 'Accesso negato, contattare l\'amministratore',
  ],
  'table' => [
    'registered_for_branch' => 'Macchine registrate per la filiale: :branch',
    'alias' => 'Alias',
    'machine_id' => 'ID macchina',
    'status' => 'Stato',
    'last_seen' => 'Visto l\'ultima volta',
    'registered' => 'Registrato',
    'actions' => 'Azioni',
    'no_alias' => 'Nessun pseudonimo',
    'never' => 'Mai',
    'no_machines' => 'Nessuna macchina registrata',
    'no_machines_hint' => 'I dispositivi verranno visualizzati qui quando gli utenti li registrano dalla pagina POS.',
  ],
  'actions' => [
    'approve' => 'Approvare',
    'decline' => 'Declino',
    'save' => 'Salva',
    'cancel' => 'Cancellare',
    'edit' => 'Modificare',
    'delete' => 'Eliminare',
  ],
  'usage' => [
    'title' => 'Utilizzo della macchina POS (:mese anno)',
    'no_data' => 'Nessun terminale POS trovato per questo ristorante in :monthYear',
    'headers' => [
      'no' => 'NO.',
      'alias' => 'Alias ​​della macchina',
      'branch' => 'Ramo',
      'machine_id' => 'ID macchina',
      'status' => 'Stato',
      'orders_current_month' => 'Ordini (mese corrente)',
      'revenue_current_month' => 'Entrate (mese corrente)',
      'last_seen' => 'Visto l\'ultima volta',
    ],
  ],
  'machines' => [
    'title' => 'Gestione delle macchine POS',
    'pending_approvals' => 'Approvazioni in sospeso (:count)',
    'filters' => [
      'all' => 'Tutte le macchine',
      'active' => 'Attivo',
      'pending' => 'In attesa di',
      'declined' => 'Rifiutato',
    ],
    'table' => [
      'alias' => 'Alias',
      'machine_id' => 'ID macchina',
      'status' => 'Stato',
      'last_seen' => 'Visto l\'ultima volta',
      'created' => 'Creato',
      'actions' => 'Azioni',
      'no_alias' => 'Nessun pseudonimo',
    ],
    'buttons' => [
      'view' => 'Visualizzazione',
      'approve' => 'Approvare',
      'edit' => 'Modificare',
      'decline' => 'Declino',
    ],
    'empty' => [
      'title' => 'Nessuna macchina registrata',
      'hint' => 'I dispositivi verranno visualizzati qui una volta registrati dalla pagina POS.',
    ],
    'modal' => [
      'title' => 'Dettagli della macchina',
      'statistics' => 'Statistiche',
      'total_orders' => 'Ordini totali',
      'today_orders' => 'Gli ordini di oggi',
    ],
    'confirm' => [
      'approve' => 'Approvare questo POS?',
      'decline' => 'Disattivare questo dispositivo POS? Sarà necessario registrarsi nuovamente.',
    ],
  ],
  'reports' => [
    'title' => 'Rapporto sulla macchina POS',
    'filter' => 'Filtro',
    'export_csv' => 'Esporta CSV',
    'customDateRange' => 'Intervallo di date personalizzato',
    'pos_only' => 'Solo POS saggio',
    'pos_machine' => 'Macchina POS',
    'cards' => [
      'total_machines' => 'Macchine totali',
      'total_orders' => 'Ordini totali',
      'net_sales' => 'Vendite nette',
      'avg_order_value' => 'Valore medio dell\'ordine',
    ],
    'table' => [
      'title' => 'Prestazioni della macchina',
      'pos_machine' => 'Macchina POS',
      'orders' => 'Ordini',
      'net_sales' => 'Vendite nette',
      'avg_order' => 'Ordine medio',
      'cash_sales' => 'Vendite in contanti',
      'card_upi_sales' => 'Vendite carta/UPI',
      'refunds' => 'Rimborsi',
    ],
    'empty' => [
      'title' => 'Nessun dato disponibile',
      'hint' => 'Prova a selezionare un intervallo di date diverso.',
    ],
  ],
  'registration' => [
    'declined' => [
      'title' => 'Registrazione rifiutata',
      'message' => 'La tua richiesta di registrazione al POS è stata rifiutata. Contatta l\'amministratore per ricevere assistenza.',
      'check_status' => 'Controlla di nuovo lo stato',
    ],
    'pending' => [
      'title' => 'Registrazione in sospeso',
      'message' => 'In attesa dell\'approvazione dell\'amministratore. L\'accesso al POS è attualmente bloccato finché il tuo dispositivo non sarà approvato.',
      'refresh_status' => 'Aggiorna stato',
      'approve_this_machine' => 'Approva questa macchina',
      'go_to_settings' => 'Vai su Impostazioni',
    ],
    'active' => [
      'label' => 'POS:',
    ],
    'limit_reached' => [
      'title' => 'Limite macchina POS raggiunto',
      'message' => 'Limite macchina POS raggiunto per questo ramo (limite: :limit). Contatta il tuo amministratore.',
      'what_can_you_do' => 'Cosa puoi fare?',
      'hint' => 'Contatta l\'amministratore per aumentare il limite delle macchine POS o rimuovere le macchine inattive.',
    ],
    'form' => [
      'title' => 'Registra questo dispositivo come POS',
      'description' => 'Per utilizzare il sistema POS, questo dispositivo deve essere registrato. Tutti gli ordini saranno collegati a questo dispositivo.',
      'select_branch' => 'Seleziona Ramo',
      'select_branch_placeholder' => 'Scegli una filiale...',
      'select_branch_error' => 'Seleziona una filiale',
      'device_name' => 'Nome dispositivo (facoltativo)',
      'device_name_placeholder' => 'ad esempio, bancone 1, bar POS, chiosco 1',
      'device_name_hint' => 'Assegna a questo dispositivo un nome descrittivo per una facile identificazione.',
      'what_happens_next' => 'Cosa succede dopo?',
      'what_happens_next_text' => 'Dopo la registrazione, avrai bisogno dell\'approvazione dell\'amministratore prima che il dispositivo diventi attivo.',
      'register_button' => 'Registra dispositivo',
      'cancel_button' => 'Annulla e torna indietro',
      'go_to_dashboard' => 'Vai alla dashboard',
    ],
    'device' => 'Dispositivo',
    'already_registered' => 'Questo dispositivo è già registrato come :alias.',
    'limit_reached_error' => 'Limite macchina POS raggiunto per questo ramo (limite: :limit). Contatta il tuo amministratore.',
    'registered_success' => 'Dispositivo POS registrato e attivato correttamente come :alias (:public_id)',
    'registered_pending' => 'La tua richiesta di registrazione è stata inviata. In attesa dell\'approvazione dell\'amministratore. Potrai utilizzare il POS una volta approvato.',
  ],
  'settings' => [
    'machine_not_pending' => 'La macchina non è in attesa di approvazione',
    'user_not_found' => 'Utente non trovato',
    'machine_approved' => 'Macchina approvata con successo',
    'machine_already_declined' => 'La macchina è già stata rifiutata',
    'machine_declined' => 'La macchina è stata rifiutata con successo',
    'alias_required' => 'L\'alias è obbligatorio',
    'machine_updated' => 'Macchina aggiornata con successo',
    'machine_deleted' => 'Macchina eliminata correttamente',
    'delete_machine_title' => 'Eliminare la macchina POS?',
    'delete_machine_message' => 'Sei sicuro di voler eliminare questo dispositivo POS? Questa azione non può essere annullata.',
  ],
  'js' => [
    'network_error' => 'La risposta della rete non è stata ok',
    'error_checking_limit' => '',
    'limit_reached_message' => 'Limite macchina POS raggiunto per questo ramo (limite: :limit). Contatta il tuo amministratore.',
    'error_loading_report' => 'Errore durante il caricamento dei dati del rapporto. Per favore riprova.',
    'edit_coming_soon' => 'Funzionalità di modifica disponibile a breve',
    'unnamed' => 'Senza nome',
  ],
  'dashboard' => [
    'title' => 'Gestione MultiPOS',
    'manage_terminals' => 'Gestisci terminali',
    'settings' => 'Impostazioni',
    'pos_machines_branch' => 'POS (Filiale)',
    'unlimited' => 'Illimitato',
    'active_limit' => '(Attivo/Limite)',
    'pending_label' => 'In attesa di:',
    'total_terminals' => 'Terminali totali',
    'active_orders' => 'Ordini attivi',
    'todays_revenue' => 'Le entrate di oggi',
    'total_tables' => 'Tabelle totali',
    'quick_actions' => 'Azioni rapide',
    'pos_terminal' => 'Terminale POS',
    'take_orders' => 'Prendi ordini',
    'configure_pos_terminals' => 'Configura i terminali POS',
    'configure_multipos' => 'Configura MultiPOS',
    'branch_label' => 'Ramo:',
    'used_label' => 'Usato:',
  ],
  'claim' => [
    'title' => 'Registra questo dispositivo come POS',
    'description' => 'Questo registrerà il tuo dispositivo attuale per tenere traccia degli ordini e delle sessioni del registratore di cassa.',
    'branch_label' => 'Ramo',
    'branch_required' => 'Ramo',
    'select_branch' => 'Seleziona un ramo',
    'device_alias_label' => 'Alias ​​dispositivo (facoltativo)',
    'device_alias_placeholder' => 'ad esempio, bancone 1, bar POS, chiosco 1',
    'device_alias_hint' => 'Assegna a questo dispositivo un nome descrittivo per una facile identificazione.',
    'what_happens_next_title' => 'Cosa succede dopo?',
    'what_happens_next_message' => 'Dopo la registrazione, questo dispositivo verrà tracciato per tutti gli ordini e transazioni. Potrebbe essere necessario che l\'amministratore approvi questo dispositivo prima che diventi attivo.',
    'cancel' => 'Cancellare',
    'register_device' => 'Registra dispositivo',
    'select_branch_alert' => 'Seleziona una filiale',
  ],
  'terminals' => [
    'title' => 'Gestione Terminali POS',
    'pos_terminals' => 'Terminali POS',
    'add_terminal' => 'Aggiungi terminale',
    'back_to_dashboard' => 'Torna alla dashboard',
    'edit_terminal' => 'Modifica terminale',
    'delete_terminal' => 'Eliminare',
    'no_terminals' => 'Nessun terminale',
    'get_started' => 'Inizia creando un nuovo terminale POS.',
    'terminal_name' => 'Nome del terminale',
    'type' => 'Tipo',
    'active' => 'Attivo',
    'cancel' => 'Cancellare',
    'save' => 'Salva',
    'delete_confirm' => 'Sei sicuro di voler eliminare questo terminale?',
    'table' => [
      'name' => 'Nome',
      'type' => 'Tipo',
      'printer' => 'Stampante',
      'status' => 'Stato',
      'default' => 'Predefinito',
      'actions' => 'Azioni',
    ],
    'status' => [
      'active' => 'Attivo',
      'inactive' => 'Inattivo',
    ],
    'type_options' => [
      'food' => 'Cibo',
      'beverage' => 'Bevanda',
      'general' => 'Generale',
    ],
    'no_printer' => 'Nessuna stampante',
    'default' => 'Predefinito',
  ],
  'package' => [
    'multiposLimit' => 'Limite macchina MultiPOS',
    'multiposLimitInfo' => 'Questo è un limite a livello di ramo. Inserisci -1 per un numero illimitato di macchine POS per filiale. Lascia vuoto o imposta un numero positivo per impostare un limite per ramo.',
  ],
  'notifications' => [
    'pos_request' => [
      'subject' => 'Richiesta di registrazione di una nuova macchina POS',
      'push_title' => 'Richiesta di registrazione POS',
      'push_message' => ':alias ha richiesto l\'accesso POS per la filiale :branch',
      'text1' => 'È stata inviata una nuova richiesta di registrazione della macchina POS.',
      'text2' => 'Si prega di rivedere e approvare o rifiutare la richiesta:',
      'text3' => 'Puoi gestire tutte le richieste della macchina POS dalla pagina delle impostazioni MultiPOS.',
      'action' => 'Richiesta di revisione',
    ],
  ],
];