<?php 
return [
  'settings_title' => 'MultiPOS-instellingen',
  'help_text' => 'Beheer en configureer uw kassamachines',
  'info' => [
    'registration_title' => 'Machineregistratie',
    'registration_text' => 'Wanneer gebruikers de POS-pagina openen zonder een geregistreerd apparaat, wordt hen gevraagd dit te registreren. Nieuwe registraties verschijnen als \'In behandeling\' en vereisen goedkeuring.',
    'status_title' => 'Statusgids',
    'status_active' => 'Actief',
    'status_pending' => 'In behandeling',
    'status_declined' => 'Afgewezen',
    'status_active_text' => 'Goedgekeurd en kan bestellingen verwerken',
    'status_pending_text' => 'In afwachting van goedkeuring',
    'status_declined_text' => 'Toegang geweigerd, neem contact op met de beheerder',
  ],
  'table' => [
    'registered_for_branch' => 'Geregistreerde machines voor vestiging: :branch',
    'alias' => 'Alias',
    'machine_id' => 'Machine-ID',
    'status' => 'Status',
    'last_seen' => 'Laatst gezien',
    'registered' => 'Geregistreerd',
    'actions' => 'Acties',
    'no_alias' => 'Geen alias',
    'never' => 'Nooit',
    'no_machines' => 'Geen machines geregistreerd',
    'no_machines_hint' => 'Apparaten worden hier weergegeven wanneer gebruikers ze registreren vanaf de POS-pagina.',
  ],
  'actions' => [
    'approve' => 'Goedkeuren',
    'decline' => 'Afwijzen',
    'save' => 'Redden',
    'cancel' => 'Annuleren',
    'edit' => 'Bewerking',
    'delete' => 'Verwijderen',
  ],
  'usage' => [
    'title' => 'POS-machinegebruik (:maand jaar)',
    'no_data' => 'Geen kassaautomaten gevonden voor dit restaurant in :monthYear',
    'headers' => [
      'no' => 'Nee.',
      'alias' => 'Machinealias',
      'branch' => 'Tak',
      'machine_id' => 'Machine-ID',
      'status' => 'Status',
      'orders_current_month' => 'Bestellingen (huidige maand)',
      'revenue_current_month' => 'Opbrengst (huidige maand)',
      'last_seen' => 'Laatst gezien',
    ],
  ],
  'machines' => [
    'title' => 'Beheer van POS-machines',
    'pending_approvals' => 'Goedkeuringen in behandeling (:count)',
    'filters' => [
      'all' => 'Alle Machines',
      'active' => 'Actief',
      'pending' => 'In behandeling',
      'declined' => 'Afgewezen',
    ],
    'table' => [
      'alias' => 'Alias',
      'machine_id' => 'Machine-ID',
      'status' => 'Status',
      'last_seen' => 'Laatst gezien',
      'created' => 'Gemaakt',
      'actions' => 'Acties',
      'no_alias' => 'Geen alias',
    ],
    'buttons' => [
      'view' => 'Weergave',
      'approve' => 'Goedkeuren',
      'edit' => 'Bewerking',
      'decline' => 'Afwijzen',
    ],
    'empty' => [
      'title' => 'Geen machines geregistreerd',
      'hint' => 'Apparaten verschijnen hier zodra ze zijn geregistreerd vanaf de POS-pagina.',
    ],
    'modal' => [
      'title' => 'Machinedetails',
      'statistics' => 'Statistieken',
      'total_orders' => 'Totaal aantal bestellingen',
      'today_orders' => 'De bestellingen van vandaag',
    ],
    'confirm' => [
      'approve' => 'Deze kassaautomaat goedkeuren?',
      'decline' => 'Deze kassaautomaat uitschakelen? Er zal opnieuw moeten worden geregistreerd.',
    ],
  ],
  'reports' => [
    'title' => 'POS-machinerapport',
    'filter' => 'Filter',
    'export_csv' => 'CSV exporteren',
    'customDateRange' => 'Aangepast datumbereik',
    'pos_only' => 'Alleen POS-wijs',
    'pos_machine' => 'POS-machine',
    'cards' => [
      'total_machines' => 'Totaal machines',
      'total_orders' => 'Totaal aantal bestellingen',
      'net_sales' => 'Netto omzet',
      'avg_order_value' => 'Gem. bestelwaarde',
    ],
    'table' => [
      'title' => 'Machineprestaties',
      'pos_machine' => 'POS-machine',
      'orders' => 'Bestellingen',
      'net_sales' => 'Netto omzet',
      'avg_order' => 'Gem. bestelling',
      'cash_sales' => 'Contante verkoop',
      'card_upi_sales' => 'Kaart-/UPI-verkoop',
      'refunds' => 'Terugbetalingen',
    ],
    'empty' => [
      'title' => 'Geen gegevens beschikbaar',
      'hint' => 'Probeer een ander datumbereik te selecteren.',
    ],
  ],
  'registration' => [
    'declined' => [
      'title' => 'Registratie geweigerd',
      'message' => 'Uw POS-registratieverzoek is afgewezen. Neem voor hulp contact op met uw beheerder.',
      'check_status' => 'Controleer de status opnieuw',
    ],
    'pending' => [
      'title' => 'Registratie in behandeling',
      'message' => 'Wachten op goedkeuring van de beheerder. POS-toegang is momenteel geblokkeerd totdat uw apparaat is goedgekeurd.',
      'refresh_status' => 'Vernieuwingsstatus',
      'approve_this_machine' => 'Keur deze machine goed',
      'go_to_settings' => 'Ga naar Instellingen',
    ],
    'active' => [
      'label' => 'POS:',
    ],
    'limit_reached' => [
      'title' => 'POS-machinelimiet bereikt',
      'message' => 'POS-machinelimiet bereikt voor dit filiaal (limiet: :limit). Neem contact op met uw beheerder.',
      'what_can_you_do' => 'Wat kun je doen?',
      'hint' => 'Neem contact op met uw beheerder om de limiet voor POS-machines te verhogen of inactieve machines te verwijderen.',
    ],
    'form' => [
      'title' => 'Registreer dit apparaat als een POS',
      'description' => 'Om het kassasysteem te kunnen gebruiken, moet dit apparaat geregistreerd zijn. Alle bestellingen worden aan dit apparaat gekoppeld.',
      'select_branch' => 'Selecteer Filiaal',
      'select_branch_placeholder' => 'Kies een vestiging...',
      'select_branch_error' => 'Selecteer een filiaal',
      'device_name' => 'Apparaatnaam (optioneel)',
      'device_name_placeholder' => 'bijv. Balie 1, Bar POS, Kiosk 1',
      'device_name_hint' => 'Geef dit apparaat een beschrijvende naam voor gemakkelijke identificatie.',
      'what_happens_next' => 'Wat gebeurt er daarna?',
      'what_happens_next_text' => 'Na registratie heeft u goedkeuring van de beheerder nodig voordat het apparaat actief wordt.',
      'register_button' => 'Apparaat registreren',
      'cancel_button' => 'Annuleer en ga terug',
      'go_to_dashboard' => 'Ga naar Dashboard',
    ],
    'device' => 'Apparaat',
    'already_registered' => 'Dit apparaat is al geregistreerd als :alias.',
    'limit_reached_error' => 'POS-machinelimiet bereikt voor dit filiaal (limiet: :limit). Neem contact op met uw beheerder.',
    'registered_success' => 'POS-apparaat geregistreerd en succesvol geactiveerd als :alias (:public_id)',
    'registered_pending' => 'Uw registratieverzoek is verzonden. Wachten op goedkeuring van de beheerder. Na goedkeuring kunt u het POS gebruiken.',
  ],
  'settings' => [
    'machine_not_pending' => 'Machine wacht niet op goedkeuring',
    'user_not_found' => 'Gebruiker niet gevonden',
    'machine_approved' => 'Machine succesvol goedgekeurd',
    'machine_already_declined' => 'Machine is al geweigerd',
    'machine_declined' => 'Machine is succesvol geweigerd',
    'alias_required' => 'Alias ​​is vereist',
    'machine_updated' => 'Machine succesvol bijgewerkt',
    'machine_deleted' => 'Machine succesvol verwijderd',
    'delete_machine_title' => 'POS-machine verwijderen?',
    'delete_machine_message' => 'Weet u zeker dat u deze kassaautomaat wilt verwijderen? Deze actie kan niet ongedaan worden gemaakt.',
  ],
  'js' => [
    'network_error' => 'Netwerkreactie was niet in orde',
    'error_checking_limit' => 'Fout bij het controleren van de vertakkingslimiet',
    'limit_reached_message' => 'POS-machinelimiet bereikt voor dit filiaal (limiet: :limit). Neem contact op met uw beheerder.',
    'error_loading_report' => 'Fout bij het laden van rapportgegevens. Probeer het opnieuw.',
    'edit_coming_soon' => 'Bewerkingsfunctionaliteit binnenkort beschikbaar',
    'unnamed' => 'Naamloos',
  ],
  'dashboard' => [
    'title' => 'MultiPOS-beheer',
    'manage_terminals' => 'Beheer terminals',
    'settings' => 'Instellingen',
    'pos_machines_branch' => 'POS-automaten (filiaal)',
    'unlimited' => 'Onbeperkt',
    'active_limit' => '(Actief / Limiet)',
    'pending_label' => 'In behandeling:',
    'total_terminals' => 'Totaal terminals',
    'active_orders' => 'Actieve bestellingen',
    'todays_revenue' => 'De inkomsten van vandaag',
    'total_tables' => 'Totaal tabellen',
    'quick_actions' => 'Snelle acties',
    'pos_terminal' => 'POS-terminal',
    'take_orders' => 'Neem bestellingen op',
    'configure_pos_terminals' => 'Configureer POS-terminals',
    'configure_multipos' => 'Configureer MultiPOS',
    'branch_label' => 'Tak:',
    'used_label' => 'Gebruikt:',
  ],
  'claim' => [
    'title' => 'Registreer dit apparaat als een POS',
    'description' => 'Hiermee wordt uw huidige apparaat geregistreerd om bestellingen en kassasessies te volgen.',
    'branch_label' => 'Tak',
    'branch_required' => 'Tak',
    'select_branch' => 'Selecteer een filiaal',
    'device_alias_label' => 'Apparaatalias (optioneel)',
    'device_alias_placeholder' => 'bijv. Balie 1, Bar POS, Kiosk 1',
    'device_alias_hint' => 'Geef dit apparaat een beschrijvende naam voor gemakkelijke identificatie.',
    'what_happens_next_title' => 'Wat gebeurt er daarna?',
    'what_happens_next_message' => 'Na registratie wordt dit apparaat gevolgd voor alle bestellingen en transacties. Uw beheerder moet dit apparaat mogelijk goedkeuren voordat het actief wordt.',
    'cancel' => 'Annuleren',
    'register_device' => 'Apparaat registreren',
    'select_branch_alert' => 'Selecteer een filiaal',
  ],
  'terminals' => [
    'title' => 'Beheer van POS-terminals',
    'pos_terminals' => 'POS-terminals',
    'add_terminal' => 'Terminal toevoegen',
    'back_to_dashboard' => 'Terug naar Dashboard',
    'edit_terminal' => 'Terminal bewerken',
    'delete_terminal' => 'Verwijderen',
    'no_terminals' => 'Geen terminals',
    'get_started' => 'Ga aan de slag door een nieuwe POS-terminal te maken.',
    'terminal_name' => 'Terminalnaam',
    'type' => 'Type',
    'active' => 'Actief',
    'cancel' => 'Annuleren',
    'save' => 'Redden',
    'delete_confirm' => 'Weet u zeker dat u deze terminal wilt verwijderen?',
    'table' => [
      'name' => 'Naam',
      'type' => 'Type',
      'printer' => 'Printer',
      'status' => 'Status',
      'default' => 'Standaard',
      'actions' => 'Acties',
    ],
    'status' => [
      'active' => 'Actief',
      'inactive' => 'Inactief',
    ],
    'type_options' => [
      'food' => 'Voedsel',
      'beverage' => 'Drank',
      'general' => 'Algemeen',
    ],
    'no_printer' => 'Geen printer',
    'default' => 'Standaard',
  ],
  'package' => [
    'multiposLimit' => 'MultiPOS-machinelimiet',
    'multiposLimitInfo' => 'Dit is een limiet per branche. Vul -1 in voor onbeperkte kassaautomaten per filiaal. Laat dit leeg of stel een positief getal in om een ​​limiet per filiaal in te stellen.',
  ],
  'notifications' => [
    'pos_request' => [
      'subject' => 'Nieuw POS-machineregistratieverzoek',
      'push_title' => 'POS-registratieverzoek',
      'push_message' => ':alias heeft POS-toegang aangevraagd voor :branch-filiaal',
      'text1' => 'Er is een nieuwe registratieaanvraag voor een kassaautomaat ingediend.',
      'text2' => 'Controleer het verzoek en keur het goed of weiger het:',
      'text3' => 'U kunt alle POS-machineverzoeken beheren vanaf de MultiPOS-instellingenpagina.',
      'action' => 'Beoordelingsverzoek',
    ],
  ],
];