<?php 
return [
  'settings_title' => 'Настройки МультиПОС',
  'help_text' => 'Управляйте и настраивайте свои POS-машины',
  'info' => [
    'registration_title' => 'Регистрация машины',
    'registration_text' => 'Когда пользователи заходят на страницу POS без зарегистрированного устройства, им будет предложено зарегистрировать его. Новые регистрации отображаются как «Ожидающие» и требуют одобрения.',
    'status_title' => 'Руководство по статусу',
    'status_active' => 'Активный',
    'status_pending' => 'В ожидании',
    'status_declined' => 'Отклоненный',
    'status_active_text' => 'Одобрено и можем обрабатывать заказы',
    'status_pending_text' => 'Ожидает одобрения',
    'status_declined_text' => 'Доступ запрещен, обратитесь к администратору',
  ],
  'table' => [
    'registered_for_branch' => 'Зарегистрированные машины для филиала: :branch',
    'alias' => 'Псевдоним',
    'machine_id' => 'Идентификатор машины',
    'status' => 'Статус',
    'last_seen' => 'Последний визит',
    'registered' => 'Зарегистрирован',
    'actions' => 'Действия',
    'no_alias' => 'Нет псевдонима',
    'never' => 'Никогда',
    'no_machines' => 'Ни одна машина не зарегистрирована',
    'no_machines_hint' => 'Устройства появятся здесь, когда пользователи зарегистрируют их на странице POS.',
  ],
  'actions' => [
    'approve' => 'Утвердить',
    'decline' => 'Отклонить',
    'save' => 'Сохранять',
    'cancel' => 'Отмена',
    'edit' => 'Редактировать',
    'delete' => 'Удалить',
  ],
  'usage' => [
    'title' => 'Использование POS-терминала (:месяц, год)',
    'no_data' => 'Для этого ресторана в :monthYear не найдено POS-терминалов.',
    'headers' => [
      'no' => 'Нет.',
      'alias' => 'Псевдоним машины',
      'branch' => 'Ветвь',
      'machine_id' => 'Идентификатор машины',
      'status' => 'Статус',
      'orders_current_month' => 'Заказы (текущий месяц)',
      'revenue_current_month' => 'Доход (текущий месяц)',
      'last_seen' => 'Последний визит',
    ],
  ],
  'machines' => [
    'title' => 'Управление POS-машинами',
    'pending_approvals' => 'Ожидающие одобрения (:count)',
    'filters' => [
      'all' => 'Все машины',
      'active' => 'Активный',
      'pending' => 'В ожидании',
      'declined' => 'Отклоненный',
    ],
    'table' => [
      'alias' => 'Псевдоним',
      'machine_id' => 'Идентификатор машины',
      'status' => 'Статус',
      'last_seen' => 'Последний визит',
      'created' => 'Созданный',
      'actions' => 'Действия',
      'no_alias' => 'Нет псевдонима',
    ],
    'buttons' => [
      'view' => 'Вид',
      'approve' => 'Утвердить',
      'edit' => 'Редактировать',
      'decline' => 'Отклонить',
    ],
    'empty' => [
      'title' => 'Ни одна машина не зарегистрирована',
      'hint' => 'Устройства появятся здесь после их регистрации на странице POS.',
    ],
    'modal' => [
      'title' => 'Детали машины',
      'statistics' => 'Статистика',
      'total_orders' => 'Всего заказов',
      'today_orders' => 'Сегодняшние заказы',
    ],
    'confirm' => [
      'approve' => 'Одобрить этот POS-терминал?',
      'decline' => 'Отключить этот POS-терминал? Ему придется пройти перерегистрацию.',
    ],
  ],
  'reports' => [
    'title' => 'Отчет о POS-машине',
    'filter' => 'Фильтр',
    'export_csv' => 'Экспорт CSV',
    'customDateRange' => 'Пользовательский диапазон дат',
    'pos_only' => 'Только POS-терминал',
    'pos_machine' => 'POS-машина',
    'cards' => [
      'total_machines' => 'Всего машин',
      'total_orders' => 'Всего заказов',
      'net_sales' => 'Чистые продажи',
      'avg_order_value' => 'Средняя стоимость заказа',
    ],
    'table' => [
      'title' => 'Производительность машины',
      'pos_machine' => 'POS-машина',
      'orders' => 'Заказы',
      'net_sales' => 'Чистые продажи',
      'avg_order' => 'Средний заказ',
      'cash_sales' => 'Продажа за наличные',
      'card_upi_sales' => 'Продажа карт/UPI',
      'refunds' => 'Возвраты',
    ],
    'empty' => [
      'title' => 'Нет доступных данных',
      'hint' => 'Попробуйте выбрать другой диапазон дат.',
    ],
  ],
  'registration' => [
    'declined' => [
      'title' => 'Регистрация отклонена',
      'message' => 'Ваш запрос на регистрацию POS был отклонен. Обратитесь за помощью к своему администратору.',
      'check_status' => 'Проверьте статус еще раз',
    ],
    'pending' => [
      'title' => 'Ожидается регистрация',
      'message' => 'Ждем одобрения администратора. Доступ к POS-терминалу в настоящее время заблокирован до тех пор, пока ваше устройство не будет одобрено.',
      'refresh_status' => 'Обновить статус',
      'approve_this_machine' => 'Одобрить эту машину',
      'go_to_settings' => 'Зайдите в настройки',
    ],
    'active' => [
      'label' => 'ПОС:',
    ],
    'limit_reached' => [
      'title' => 'Достигнут лимит POS-машин',
      'message' => 'Для этого филиала достигнут лимит POS-терминалов (лимит: :limit). Пожалуйста, свяжитесь с вашим администратором.',
      'what_can_you_do' => 'Что ты можешь сделать?',
      'hint' => 'Обратитесь к своему администратору, чтобы увеличить лимит POS-терминалов или удалить неактивные автоматы.',
    ],
    'form' => [
      'title' => 'Зарегистрируйте это устройство как POS',
      'description' => 'Для использования POS-системы это устройство необходимо зарегистрировать. Все заказы будут привязаны к этому устройству.',
      'select_branch' => 'Выберите филиал',
      'select_branch_placeholder' => 'Выберите ветку...',
      'select_branch_error' => 'Пожалуйста, выберите филиал',
      'device_name' => 'Имя устройства (необязательно)',
      'device_name_placeholder' => 'например, стойка 1, POS-терминал в баре, киоск 1.',
      'device_name_hint' => 'Дайте этому устройству понятное имя для облегчения идентификации.',
      'what_happens_next' => 'Что произойдет дальше?',
      'what_happens_next_text' => 'После регистрации вам потребуется одобрение администратора, прежде чем устройство станет активным.',
      'register_button' => 'Зарегистрировать устройство',
      'cancel_button' => 'Отменить и вернуться назад',
      'go_to_dashboard' => 'Перейти на панель управления',
    ],
    'device' => 'Устройство',
    'already_registered' => 'Это устройство уже зарегистрировано как :alias.',
    'limit_reached_error' => 'Для этого филиала достигнут лимит POS-терминалов (лимит: :limit). Пожалуйста, свяжитесь с вашим администратором.',
    'registered_success' => 'POS-устройство зарегистрировано и успешно активировано как :alias (:public_id)',
    'registered_pending' => 'Ваш запрос на регистрацию отправлен. Ждем одобрения администратора. Вы сможете использовать POS после одобрения.',
  ],
  'settings' => [
    'machine_not_pending' => 'Машина не ожидает одобрения',
    'user_not_found' => 'Пользователь не найден',
    'machine_approved' => 'Машина успешно одобрена',
    'machine_already_declined' => 'Машина уже отклонена',
    'machine_declined' => 'Машина успешно отклонилась',
    'alias_required' => 'Требуется псевдоним',
    'machine_updated' => 'Машина успешно обновлена',
    'machine_deleted' => 'Машина успешно удалена',
    'delete_machine_title' => 'Удалить POS-терминал?',
    'delete_machine_message' => 'Вы уверены, что хотите удалить этот POS-терминал? Это действие невозможно отменить.',
  ],
  'js' => [
    'network_error' => 'Ответ сети был не в порядке',
    'error_checking_limit' => 'Ошибка проверки лимита ветвей',
    'limit_reached_message' => 'Для этого филиала достигнут лимит POS-терминалов (лимит: :limit). Пожалуйста, свяжитесь с вашим администратором.',
    'error_loading_report' => 'Ошибка загрузки данных отчета. Пожалуйста, попробуйте еще раз.',
    'edit_coming_soon' => 'Функция редактирования появится в ближайшее время',
    'unnamed' => 'Безымянный',
  ],
  'dashboard' => [
    'title' => 'Управление мультиPOS',
    'manage_terminals' => 'Управление терминалами',
    'settings' => 'Настройки',
    'pos_machines_branch' => 'POS-аппараты (филиал)',
    'unlimited' => 'Безлимитный',
    'active_limit' => '(Активный/Ограниченный)',
    'pending_label' => 'В ожидании:',
    'total_terminals' => 'Всего терминалов',
    'active_orders' => 'Активные заказы',
    'todays_revenue' => 'Сегодняшний доход',
    'total_tables' => 'Всего таблиц',
    'quick_actions' => 'Быстрые действия',
    'pos_terminal' => 'POS-терминал',
    'take_orders' => 'Принимайте заказы',
    'configure_pos_terminals' => 'Настроить POS-терминалы',
    'configure_multipos' => 'Настроить МультиПОС',
    'branch_label' => 'Ветвь:',
    'used_label' => 'Использовал:',
  ],
  'claim' => [
    'title' => 'Зарегистрируйте это устройство как POS',
    'description' => 'Это зарегистрирует ваше текущее устройство для отслеживания заказов и сеансов кассового аппарата.',
    'branch_label' => 'Ветвь',
    'branch_required' => 'Ветвь',
    'select_branch' => 'Выберите филиал',
    'device_alias_label' => 'Псевдоним устройства (необязательно)',
    'device_alias_placeholder' => 'например, стойка 1, POS-терминал в баре, киоск 1.',
    'device_alias_hint' => 'Дайте этому устройству понятное имя для облегчения идентификации.',
    'what_happens_next_title' => 'Что произойдет дальше?',
    'what_happens_next_message' => 'После регистрации на этом устройстве будут отслеживаться все заказы и транзакции. Вашему администратору может потребоваться одобрить это устройство, прежде чем оно станет активным.',
    'cancel' => 'Отмена',
    'register_device' => 'Зарегистрировать устройство',
    'select_branch_alert' => 'Пожалуйста, выберите филиал',
  ],
  'terminals' => [
    'title' => 'Управление POS-терминалами',
    'pos_terminals' => 'POS-терминалы',
    'add_terminal' => 'Добавить терминал',
    'back_to_dashboard' => 'Вернуться к панели управления',
    'edit_terminal' => 'Редактировать терминал',
    'delete_terminal' => 'Удалить',
    'no_terminals' => 'Нет терминалов',
    'get_started' => 'Начните с создания нового POS-терминала.',
    'terminal_name' => 'Имя терминала',
    'type' => 'Тип',
    'active' => 'Активный',
    'cancel' => 'Отмена',
    'save' => 'Сохранять',
    'delete_confirm' => 'Вы уверены, что хотите удалить этот терминал?',
    'table' => [
      'name' => 'Имя',
      'type' => 'Тип',
      'printer' => 'Принтер',
      'status' => 'Статус',
      'default' => 'По умолчанию',
      'actions' => 'Действия',
    ],
    'status' => [
      'active' => 'Активный',
      'inactive' => 'Неактивный',
    ],
    'type_options' => [
      'food' => 'Еда',
      'beverage' => 'Напиток',
      'general' => 'Общий',
    ],
    'no_printer' => 'Нет принтера',
    'default' => 'По умолчанию',
  ],
  'package' => [
    'multiposLimit' => 'Лимит машины MultiPOS',
    'multiposLimitInfo' => 'Это отраслевой предел. Введите -1 для неограниченного количества POS-терминалов в филиале. Оставьте пустым или задайте положительное число, чтобы установить ограничение на ветку.',
  ],
  'notifications' => [
    'pos_request' => [
      'subject' => 'Запрос на регистрацию нового POS-аппарата',
      'push_title' => 'Запрос на регистрацию POS-терминала',
      'push_message' => ':alias запросил доступ к POS для филиала :branch',
      'text1' => 'Отправлен новый запрос на регистрацию POS-терминала.',
      'text2' => 'Пожалуйста, просмотрите и одобрите или отклоните запрос:',
      'text3' => 'Вы можете управлять всеми запросами POS-терминалов на странице настроек MultiPOS.',
      'action' => 'Запрос на рассмотрение',
    ],
  ],
];